const express = require('express');
const cors = require('cors');
const path = require('path'); 
const studentRoutes = require('./routes/student');
const courseRoutes = require('./routes/course');
const instituteRoutes = require('./routes/Institute');
const commonRoutes = require('./routes/common');
const applyRoutes = require('./routes/apply');
const studyAbroadRoutes = require('./routes/studyabroad'); 
const eventsRoutes = require('./routes/events'); 
const externalDegreeRoutes = require('./routes/externalDegree');
const tuitionRoutes = require('./routes/tuition');
const applicationsRoutes = require('./routes/applications');
const bankStdLoanRoutes = require('./routes/bankStdLoan');
const stdLoansRoutes = require('./routes/stdLoans');
const scholarshipsRoutes = require('./routes/scholarships'); 
const langQualificationsRoutes = require('./routes/langQualifications');
const professionalExamsRoutes = require('./routes/professionalExams'); 
const internationalSchoolsRoutes = require('./routes/internationalSchools');
const categoryRoutes = require('./routes/category');
const levelRoutes = require('./routes/level');

const app = express();
app.use(cors());
app.use(express.json());
app.use('/Upload/images', express.static('Upload/images'));

// Serve static files from the "Upload/pdf" directory
app.use('/Upload/pdf', express.static(path.join(__dirname, 'Upload/pdf')));

app.get('/', (req, res) => {
  return res.json({ message: 'Welcome to Education Management System' });
});

app.use('/std', studentRoutes); 
app.use('/ins', instituteRoutes); 
app.use('/course', courseRoutes); 
app.use('/common', commonRoutes);  
app.use('/apply', applyRoutes); 
app.use('/studyabroad', studyAbroadRoutes); 
app.use('/contactus', require('./routes/contactus')); 
app.use('/govofficer', require('./routes/Govofficer'));
app.use('/admin', require('./routes/Admin'));
app.use('/events', eventsRoutes); 
app.use('/externalDegree', externalDegreeRoutes);
app.use('/tuition', tuitionRoutes); 
app.use('/ljobs', require('./routes/Ljobs'));
app.use('/applications', applicationsRoutes); 
app.use('/bankStdLoan', bankStdLoanRoutes); 
app.use('/stdLoans', stdLoansRoutes); 
app.use('/scholarships', scholarshipsRoutes); 
app.use('/langQualifications', langQualificationsRoutes); 
app.use('/professionalExams', professionalExamsRoutes);
app.use('/internationalSchools', internationalSchoolsRoutes);
app.use('/fjobs', require('./routes/Fjobs'));
app.use('/fjobcate', require('./routes/Fjobcate'));
app.use('/adminview', require('./routes/AdminDashboardView'));
app.use('/advertisement', require('./routes/Advertisement'));
app.use('/category', categoryRoutes);
app.use('/level', levelRoutes);
app.use('/ljobcate', require('./routes/Ljobcate'));

app.listen(8081, () => {
  console.log('Server is running on port 8081');
});
